<?php
require_once __DIR__ . '/../functions.php';
require_role(['admin']);
header('Content-Type: application/json');
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { echo json_encode(['ok'=>false,'error'=>'Method not allowed']); exit; }
if (!csrf_verify($_POST['csrf'] ?? '')) { echo json_encode(['ok'=>false,'error'=>'Invalid CSRF']); exit; }
if (empty($_FILES['xlsx_file']) || $_FILES['xlsx_file']['error'] !== UPLOAD_ERR_OK) { echo json_encode(['ok'=>false,'error'=>'No file uploaded']); exit; }
$uploads = __DIR__ . '/../uploads'; if (!is_dir($uploads)) mkdir($uploads, 0755, true);
$fn = basename($_FILES['xlsx_file']['name']);
$uniq = time() . '_' . bin2hex(random_bytes(6));
$dest = $uploads . '/' . $uniq . '_' . preg_replace('/[^a-zA-Z0-9._-]/','_', $fn);
if (!move_uploaded_file($_FILES['xlsx_file']['tmp_name'], $dest)) { echo json_encode(['ok'=>false,'error'=>'Failed to move uploaded file']); exit; }
// try to get total rows using PhpSpreadsheet if available
$totalRows = null;
if (file_exists(__DIR__ . '/../vendor/autoload.php')) {
    require_once __DIR__ . '/../vendor/autoload.php';
    try {
        $ss = \PhpOffice\PhpSpreadsheet\IOFactory::load($dest);
        $sheet = $ss->getActiveSheet();
        $totalRows = (int)$sheet->getHighestRow();
    } catch (Exception $e) {
        $totalRows = null;
    }
}
echo json_encode(['ok'=>true,'file'=>basename($dest),'size'=>filesize($dest),'rows'=>$totalRows]);
