<?php
require_once __DIR__ . '/../functions.php';
require_role(['admin']);
$db = get_db();

// simple CSV export for given month/year
$month = $_GET['month'] ?? date('m');
$year = $_GET['year'] ?? date('Y');
if (isset($_GET['export']) && $_GET['export'] == 'csv') {
    $start = "$year-$month-01";
    $end = date('Y-m-t', strtotime($start));
    $stmt = $db->prepare("SELECT a.date, c.name as kelas, s.name as siswa, a.status FROM attendance a JOIN students s ON s.id=a.student_id JOIN classes c ON c.id=a.class_id WHERE a.date BETWEEN ? AND ? ORDER BY a.date, c.name, s.name");
    $stmt->bind_param('ss', $start, $end);
    $stmt->execute();
    $res = $stmt->get_result();
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="report_' . $year . '_' . $month . '.csv"');
    $out = fopen('php://output', 'w');
    fputcsv($out, ['Tanggal', 'Kelas', 'Siswa', 'Status']);
    while ($r = $res->fetch_assoc()) fputcsv($out, [$r['date'], $r['kelas'], $r['siswa'], $r['status']]);
    exit;
}

?>
<!doctype html>
<html>

<head>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
    <title>Laporan</title>
</head>

<body>
    </div>
    <?php require_once __DIR__ . '/_header.php'; ?>
    <h4>Rekapitulasi Absensi</h4>
    <form class="row g-2 mb-3">
        <div class="col-auto"><input type="month" class="form-control" id="mm" value="<?= h($year . '-' . str_pad($month, 2, '0', STR_PAD_LEFT)) ?>" onchange="(function(){var v=this.value.split('-'); window.location='reports.php?month='+v[1]+'&year='+v[0];}).call(this)"></div>
        <div class="col-auto"><a href="reports.php?export=csv&month=<?= h($month) ?>&year=<?= h($year) ?>" class="btn btn-primary">Download CSV</a></div>
    </form>

    <?php require_once __DIR__ . '/_footer.php'; ?>
</body>

</html>