<?php
require_once __DIR__ . '/../functions.php';
require_role(['admin']);
$db = get_db();
$import_processed = false;
// ensure composer autoload (for PhpSpreadsheet) is available
if (file_exists(__DIR__ . '/../vendor/autoload.php')) {
    require_once __DIR__ . '/../vendor/autoload.php';
}

// delete
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $db->prepare('DELETE FROM students WHERE id=?');
    $stmt->bind_param('i', $id);
    $stmt->execute();
    header('Location: students.php');
    exit;
}
// handle import (.xlsx)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['import_students'])) {
    if (!csrf_verify($_POST['csrf'] ?? '')) { $err = 'Invalid CSRF'; }
    elseif (empty($_FILES['xlsx_file']) || $_FILES['xlsx_file']['error'] !== UPLOAD_ERR_OK) {
        $err = 'File tidak diupload atau terjadi error saat upload.';
    } else {
        $f = $_FILES['xlsx_file'];
        $tmp = $f['tmp_name'];
        // require PhpSpreadsheet
        if (!class_exists('\PhpOffice\PhpSpreadsheet\IOFactory')) {
            $err = 'Library PhpSpreadsheet tidak ditemukan. Install dengan: composer require phpoffice/phpspreadsheet';
        } else {
            try {
                $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($tmp);
                $sheet = $spreadsheet->getActiveSheet();
                $rowIterator = $sheet->getRowIterator(2); // assume header row 1
                $inserted = 0;
                $db->begin_transaction();
                $stmtIns = $db->prepare('INSERT INTO students (name, class_id) VALUES (?, ?)');
                foreach ($rowIterator as $row) {
                    $cellIterator = $row->getCellIterator();
                    $cellIterator->setIterateOnlyExistingCells(false);
                    $cells = [];
                    foreach ($cellIterator as $cell) $cells[] = trim((string)$cell->getValue());
                    $name = $cells[0] ?? '';
                    $classCell = $cells[1] ?? '';
                    if ($name === '') continue;
                    $class_id = null;
                    if ($classCell !== '') {
                        if (is_numeric($classCell)) {
                            $class_id = (int)$classCell;
                        } else {
                            // lookup class by name
                            $stmtC = $db->prepare('SELECT id FROM classes WHERE name = ? LIMIT 1');
                            $stmtC->bind_param('s', $classCell);
                            $stmtC->execute();
                            $resC = $stmtC->get_result()->fetch_assoc();
                            if ($resC) $class_id = (int)$resC['id'];
                            $stmtC->close();
                        }
                    }
                    $cid = $class_id ?? 0;
                    $stmtIns->bind_param('si', $name, $cid);
                    $stmtIns->execute();
                    $inserted++;
                }
                $db->commit();
                $stmtIns->close();
                    $msg = "Import selesai. $inserted siswa ditambahkan.";
                    $import_processed = true;
            } catch (Exception $ex) {
                $db->rollback();
                $err = 'Gagal memproses file: ' . $ex->getMessage();
                    $import_processed = true;
            }
        }
    }
}
    // handle delete via POST (safer) or GET for backward compatibility
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete'])) {
        if (!csrf_verify($_POST['csrf'] ?? '')) { http_response_code(400); echo 'Invalid CSRF'; exit; }
        $id = (int)$_POST['delete']; $stmt=$db->prepare('DELETE FROM students WHERE id=?'); $stmt->bind_param('i',$id); $stmt->execute(); header('Location: students.php'); exit;
    } elseif (isset($_GET['delete'])) { $id=(int)$_GET['delete']; $stmt=$db->prepare('DELETE FROM students WHERE id=?'); $stmt->bind_param('i',$id); $stmt->execute(); header('Location: students.php'); exit; }

// load edit
$editing = null;
if (isset($_GET['edit'])) {
    $eid = (int)$_GET['edit'];
    $stmt = $db->prepare('SELECT id, name, class_id FROM students WHERE id = ? LIMIT 1');
    $stmt->bind_param('i', $eid);
    $stmt->execute();
    $editing = $stmt->get_result()->fetch_assoc();
}

// create or update (skip if import was processed)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !$import_processed) {
    if (!csrf_verify($_POST['csrf'] ?? '')) {
        $err = 'Invalid CSRF';
    } else {
        $name = trim($_POST['name'] ?? '');
        $class_id = (int)($_POST['class_id'] ?? 0);
        if ($name === '') {
            $err = 'Nama siswa diperlukan';
        } else {
            if (!empty($_POST['edit_id'])) {
                $edit_id = (int)$_POST['edit_id'];
                $stmt = $db->prepare('UPDATE students SET name=?, class_id=? WHERE id=?');
                $stmt->bind_param('sii', $name, $class_id, $edit_id);
                $stmt->execute();
                header('Location: students.php');
                exit;
            } else {
                $stmt = $db->prepare('INSERT INTO students (name, class_id) VALUES (?, ?)');
                $stmt->bind_param('si', $name, $class_id);
                $stmt->execute();
                header('Location: students.php');
                exit;
            }
        }
    }
}

$classes = $db->query('SELECT id, name FROM classes')->fetch_all(MYSQLI_ASSOC);
$students = $db->query('SELECT s.id, s.name, c.name as kelas FROM students s LEFT JOIN classes c ON c.id=s.class_id ORDER BY s.name')->fetch_all(MYSQLI_ASSOC);
?>
<?php require_once __DIR__ . '/_header.php'; ?>
        <h4>Manajemen Siswa</h4>
        <?php if (!empty($err)): ?><div class="alert alert-danger"><?= h($err) ?></div><?php endif; ?>
        <form method="post" class="row g-2 mb-3">
            <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
            <?php if ($editing): ?><input type="hidden" name="edit_id" value="<?= h($editing['id']) ?>"><?php endif; ?>
            <div class="col-md-4"><input name="name" class="form-control" placeholder="Nama siswa" required value="<?= h($editing['name'] ?? '') ?>"></div>
            <div class="col-md-4">
                <select name="class_id" class="form-select" required>
                    <?php foreach ($classes as $c): ?><option value="<?= h($c['id']) ?>" <?= isset($editing) && $editing['class_id'] == $c['id'] ? 'selected' : '' ?>><?= h($c['name']) ?></option><?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-4"><button class="btn btn-primary"><?= $editing ? 'Simpan Perubahan' : 'Tambah Siswa' ?></button>
                <?php if ($editing): ?> <a href="students.php" class="btn btn-outline-secondary ms-2">Batal</a><?php endif; ?>
            </div>
        </form>

        <!-- Import form (.xlsx) -->
        <div class="mb-4">
            <h6>Import Siswa (.xlsx)</h6>
            <?php if (!empty($msg)): ?><div class="alert alert-success"><?= h($msg) ?></div><?php endif; ?>
            <?php if (!empty($err)): ?><div class="alert alert-danger"><?= h($err) ?></div><?php endif; ?>
                        <form id="uploadStudentsForm" enctype="multipart/form-data" class="row g-2">
                                <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
                                <div class="col-auto">
                                        <input type="file" name="xlsx_file" id="xlsx_file" accept=".xlsx" class="form-control" required>
                                </div>
                                <div class="col-auto">
                                        <button type="button" id="startImportBtn" class="btn btn-secondary">Upload & Import</button>
                                        <a href="../assets/templates/students_template.xlsx" class="btn btn-outline-primary ms-2" download>Download Template</a>
                                </div>
                                <div class="col-12 mt-2"><small class="text-muted">Format: kolom pertama = Nama, kolom kedua = Nama Kelas atau ID Kelas (opsional). Baris pertama dianggap header.</small></div>
                        </form>
                        <div id="studentImportProgress" style="display:none;margin-top:.5rem">
                            <div>Progress: <span id="studentImportStatus">0%</span></div>
                            <div class="progress"><div id="studentImportBar" class="progress-bar" role="progressbar" style="width:0%"></div></div>
                            <pre id="studentImportLog" style="max-height:200px;overflow:auto;background:#fafafa;padding:8px;border:1px solid #eee;margin-top:8px;display:none"></pre>
                            <div id="studentImportErrors" style="display:none;margin-top:8px">
                                <h6>Errors (<span id="studentImportErrorsCount">0</span>)</h6>
                                <ol id="studentImportErrorsList" style="max-height:200px;overflow:auto;background:#fff9f9;padding:8px;border:1px solid #ffe6e6;margin-top:4px"></ol>
                            </div>
                        </div>
                        <script>
                        (function(){
                            const btn = document.getElementById('startImportBtn');
                            const fileInput = document.getElementById('xlsx_file');
                            const status = document.getElementById('studentImportStatus');
                            const bar = document.getElementById('studentImportBar');
                            const log = document.getElementById('studentImportLog');
                            const progressWrap = document.getElementById('studentImportProgress');
                            const errorsWrap = document.getElementById('studentImportErrors');
                            const errorsList = document.getElementById('studentImportErrorsList');
                            const errorsCountEl = document.getElementById('studentImportErrorsCount');
                            let errors = [];
                            let totalInserted = 0;

                            btn.addEventListener('click', function(){
                                if (!fileInput.files.length) { alert('Pilih file .xlsx terlebih dahulu'); return; }
                                // reset UI
                                errors = []; errorsList.innerHTML = ''; errorsCountEl.innerText = '0'; errorsWrap.style.display = 'none';
                                log.innerText = '';
                                bar.style.width = '0%'; status.innerText = '0%';

                                const f = fileInput.files[0];
                                const fd = new FormData(); fd.append('xlsx_file', f); fd.append('csrf', document.querySelector('input[name="csrf"]').value);
                                btn.disabled = true; btn.textContent = 'Uploading...';
                                fetch('import_students_upload.php', { method:'POST', body: fd }).then(r=>r.json()).then(j=>{
                                    if (!j.ok) { alert('Upload gagal: '+(j.error||'unknown')); btn.disabled=false; btn.textContent='Upload & Import'; return; }
                                    progressWrap.style.display='block'; log.style.display='block';
                                    const total = j.rows || 0; let offset = 2; const file = j.file; const chunk = 50;
                                    totalInserted = 0;
                                    function step(){
                                        fetch('import_students_process.php?csrf='+encodeURIComponent(document.querySelector('input[name="csrf"]').value)+
                                                    '&file='+encodeURIComponent(file)+'&offset='+offset+'&chunk='+chunk)
                                            .then(r=>r.json()).then(js=>{
                                                if (!js.ok) { log.innerText += 'Error: '+(js.error||'unknown')+'\n'; btn.disabled=false; btn.textContent='Upload & Import'; return; }
                                                offset = js.offset;
                                                const inserted = js.inserted || 0;
                                                totalInserted += inserted;
                                                log.innerText += 'Inserted: '+ inserted +' rows (processed '+ (js.processed || offset) +')\n';

                                                // collect per-row errors reported by server
                                                if (js.errors && Array.isArray(js.errors) && js.errors.length) {
                                                    js.errors.forEach(function(e){
                                                        errors.push(e);
                                                        const li = document.createElement('li');
                                                        li.textContent = e;
                                                        errorsList.appendChild(li);
                                                    });
                                                    errorsCountEl.innerText = errors.length.toString();
                                                    errorsWrap.style.display = 'block';
                                                }

                                                const percent = total ? Math.min(100, Math.round((offset/total)*100)) : 0;
                                                bar.style.width = percent + '%'; status.innerText = percent + '%';
                                                if (!js.done) setTimeout(step, 200); else {
                                                    btn.disabled=false; btn.textContent='Upload & Import';
                                                    const errCount = errors.length;
                                                    alert('Import selesai: '+ totalInserted +' inserted' + (errCount ? (', ' + errCount + ' error(s)') : ''));
                                                }
                                            }).catch(e=>{ log.innerText += 'Fetch error: '+e+'\n'; btn.disabled=false; btn.textContent='Upload & Import'; });
                                    }
                                    step();
                                }).catch(e=>{ alert('Upload error: '+e); btn.disabled=false; btn.textContent='Upload & Import'; });
                            });
                        })();
                        </script>
        </div>

        <table class="table table-striped datatable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nama</th>
                    <th>Kelas</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($students as $s): ?>
                    <tr>
                        <td><?= h($s['id']) ?></td>
                        <td><?= h($s['name']) ?></td>
                        <td><?= h($s['kelas']) ?></td>
                        <td>
                       <a href="students.php?edit=<?= h($s['id']) ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                       <a href="#" data-id="<?= h($s['id']) ?>" class="btn btn-sm btn-danger btn-delete" data-msg="Hapus siswa <?=h($s['name'])?>?">Hapus</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
    </table>
<?php require_once __DIR__ . '/_footer.php'; ?>