<?php
require_once __DIR__ . '/../functions.php';
$db = get_db();

$days = isset($_GET['days']) ? (int)$_GET['days'] : 30; // last N days
if ($days < 1) $days = 30;
$end = date('Y-m-d');
$start = date('Y-m-d', strtotime("-" . ($days-1) . " days"));

$teacher_id = isset($_GET['teacher_id']) ? (int)$_GET['teacher_id'] : null;
$class_id = isset($_GET['class_id']) ? (int)$_GET['class_id'] : null;

$labels = [];
$hadir = [];
$tidak = [];
for ($d = $days-1; $d >= 0; $d--) {
    $date = date('Y-m-d', strtotime("-{$d} days"));
    $labels[] = date('d M', strtotime($date));
    $hadir[$date] = 0; $tidak[$date] = 0;
}

$sql = "SELECT a.date as dt, SUM(a.status='Hadir') as hadir, SUM(a.status!='Hadir') as tidak
        FROM attendance a JOIN classes c ON c.id = a.class_id
        WHERE a.date BETWEEN ? AND ?";
$params = [$start, $end]; $types = 'ss';
if ($teacher_id) { $sql .= " AND c.teacher_id = ?"; $types .= 'i'; $params[] = $teacher_id; }
if ($class_id)   { $sql .= " AND a.class_id = ?"; $types .= 'i'; $params[] = $class_id; }
$sql .= " GROUP BY a.date";

$stmt = $db->prepare($sql);
$stmt->bind_param($types, ...$params);
$stmt->execute(); $res = $stmt->get_result();
while ($r = $res->fetch_assoc()) {
    $dt = $r['dt'];
    if (isset($hadir[$dt])) {
        $hadir[$dt] = (int)$r['hadir'];
        $tidak[$dt] = (int)$r['tidak'];
    }
}

$h = array_values($hadir);
$t = array_values($tidak);

header('Content-Type: application/json');
echo json_encode(['labels'=>$labels, 'hadir'=>$h, 'tidak'=>$t, 'start'=>$start, 'end'=>$end]);

?>
