<?php
require_once __DIR__ . '/functions.php';
require_login();
$db = get_db();
$user = current_user();

// load all classes (allow guru to access all classes)
$stmt = $db->prepare("SELECT id, name FROM classes ORDER BY name");
$stmt->execute();
$classes = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

$selected_class = $_GET['class'] ?? ($classes[0]['id'] ?? null);
$date = $_GET['date'] ?? date('Y-m-d');

$students = [];
if ($selected_class) {
    $stmt = $db->prepare("SELECT id, name FROM students WHERE class_id = ? ORDER BY name");
    $stmt->bind_param('i', $selected_class);
    $stmt->execute();
    $students = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    // load existing attendance for date
    $stmt = $db->prepare("SELECT student_id, status FROM attendance WHERE class_id = ? AND date = ?");
    $stmt->bind_param('is', $selected_class, $date);
    $stmt->execute();
    $rows = $stmt->get_result();
    $existing = [];
    while ($r = $rows->fetch_assoc()) $existing[$r['student_id']] = $r['status'];
} else {
    $existing = [];
}

?>
<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Absensi - Input</title>
    <link href="assets/vendor/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <!-- SweetAlert2 CSS (local preferred, CDN fallback) -->
    <?php if (file_exists(__DIR__ . '/assets/vendor/sweetalert2.min.css')): ?>
        <link rel="stylesheet" href="assets/vendor/sweetalert2.min.css">
    <?php else: ?>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <?php endif; ?>
    <link rel="stylesheet" href="assets/vendor/jquery.dataTables.min.css">
    <link rel="stylesheet" href="assets/vendor/responsive.dataTables.min.css">
</head>

<body>
    <nav class="navbar navbar-light bg-white shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="/absensi/">Absensi Siswa</a>
            <div>
                <?php if (is_logged_in()): ?>
                    <span class="me-2">Hello, <?= h($user['name']) ?> (<?= h($user['role']) ?>)</span>
                    <?php if ($user['role'] === 'admin'): ?>
                        <a href="admin/dashboard.php" class="btn btn-sm btn-success me-2">Dashboard</a>
                    <?php else: ?>
                        <a href="teacher/dashboard.php" class="btn btn-sm btn-success me-2">Dashboard</a>
                    <?php endif; ?>
                    <a href="logout.php" class="btn btn-sm btn-danger btn-logout">Logout</a>
                <?php endif; ?>
            </div>
        </div>
    </nav>

    <main class="container py-4">
        <h4>Input Absensi</h4>
        <form method="get" class="row g-2 align-items-end mb-3">
            <div class="col-auto">
                <label class="form-label">Pilih Kelas</label>
                <select name="class" class="form-select" onchange="this.form.submit()">
                    <?php foreach ($classes as $c): ?>
                        <option value="<?= h($c['id']) ?>" <?= ($c['id'] == $selected_class) ? 'selected' : '' ?>><?= h($c['name']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-auto">
                <label class="form-label">Tanggal</label>
                <input type="date" name="date" class="form-control" value="<?= h($date) ?>" onchange="this.form.submit()">
            </div>
        </form>

        <?php if (empty($students)): ?>
            <div class="alert alert-warning">Tidak ada siswa di kelas ini.</div>
        <?php else: ?>
            <form method="post" action="api/attendance_save.php">
                <input type="hidden" name="csrf" value="<?= h(csrf_token()) ?>">
                <input type="hidden" name="class_id" value="<?= h($selected_class) ?>">
                <input type="hidden" name="date" value="<?= h($date) ?>">
                <table class="table table-striped datatable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Nama</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = 1;
                        foreach ($students as $s): ?>
                            <tr>
                                <td><?= $i++ ?></td>
                                <td><?= h($s['name']) ?></td>
                                <td>
                                    <select name="status[<?= h($s['id']) ?>]" class="form-select">
                                        <?php $opts = ['Hadir', 'Sakit', 'Izin', 'Alpha'];
                                        foreach ($opts as $opt): ?>
                                            <option value="<?= h($opt) ?>" <?= isset($existing[$s['id']]) && $existing[$s['id']] == $opt ? 'selected' : '' ?>><?= h($opt) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <button class="btn btn-primary">Simpan Absensi</button>
            </form>
        <?php endif; ?>

    </main>
    <script src="assets/vendor/jquery.min.js"></script>
    <script src="assets/vendor/jquery.dataTables.min.js"></script>
    <script src="assets/vendor/dataTables.responsive.min.js"></script>
    <script src="assets/vendor/bootstrap.bundle.min.js"></script>
    <script src="assets/vendor/sweetalert2.min.js"></script>
    <script src="assets/js/admin.js"></script>
</body>

</html>