<?php
require_once __DIR__ . '/config.php';

// HTML escape
function h($s) { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

// CSRF
function csrf_token() {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function csrf_verify($token) {
    if (empty($token) || empty($_SESSION['csrf_token'])) return false;
    return hash_equals($_SESSION['csrf_token'], $token);
}

// Auth helpers
function current_user() {
    if (empty($_SESSION['user_id'])) return null;
    $db = get_db();
    $stmt = $db->prepare("SELECT id, username, name, role FROM users WHERE id = ? LIMIT 1");
    $stmt->bind_param('i', $_SESSION['user_id']);
    $stmt->execute();
    $res = $stmt->get_result();
    return $res->fetch_assoc();
}

function is_logged_in() {
    return !empty($_SESSION['user_id']);
}

function require_login() {
    if (!is_logged_in()) {
        header('Location: ' . base_url('login.php'));
        exit;
    }
}

function require_role($roles = []) {
    require_login();
    $user = current_user();
    if (!$user || !in_array($user['role'], (array)$roles)) {
        http_response_code(403);
        echo "Forbidden";
        exit;
    }
}
