<?php
// Run once to seed admin/guru/classes/students sample data.
require_once __DIR__ . '/config.php';
$db = get_db();

function run($db, $sql, $types = null, $params = []) {
    $stmt = $db->prepare($sql);
    if ($types) $stmt->bind_param($types, ...$params);
    $stmt->execute();
    return $stmt->insert_id ?: true;
}

// Create sample users
$adminPass = password_hash('admin123', PASSWORD_DEFAULT);
$guruPass = password_hash('guru123', PASSWORD_DEFAULT);

// Insert admin
$stmt = $db->prepare("SELECT id FROM users WHERE username = 'admin' LIMIT 1"); $stmt->execute(); $res = $stmt->get_result();
if (!$res->fetch_assoc()) {
    $stmt = $db->prepare("INSERT INTO users (username, password, name, role) VALUES (?, ?, ?, 'admin')");
    $u='admin'; $n='Administrator'; $stmt->bind_param('sss', $u, $adminPass, $n); $stmt->execute();
}

// Insert guru
$stmt = $db->prepare("SELECT id FROM users WHERE username = 'guru1' LIMIT 1"); $stmt->execute(); $res = $stmt->get_result();
if (!$res->fetch_assoc()) {
    $stmt = $db->prepare("INSERT INTO users (username, password, name, role) VALUES (?, ?, ?, 'guru')");
    $u='guru1'; $n='Guru Satu'; $stmt->bind_param('sss', $u, $guruPass, $n); $stmt->execute();
}

// Create sample class and assign guru
// get guru id
$stmt = $db->prepare("SELECT id FROM users WHERE username = 'guru1' LIMIT 1"); $stmt->execute(); $res = $stmt->get_result(); $g = $res->fetch_assoc(); $guru_id = $g['id'];

// create class
$stmt = $db->prepare("SELECT id FROM classes WHERE name = '10A' LIMIT 1"); $stmt->execute(); $res = $stmt->get_result();
if (!$res->fetch_assoc()) {
    $stmt = $db->prepare("INSERT INTO classes (name, teacher_id) VALUES (?, ?)");
    $name = '10A'; $stmt->bind_param('si', $name, $guru_id); $stmt->execute();
}

// fetch class id
$stmt = $db->prepare("SELECT id FROM classes WHERE name = '10A' LIMIT 1"); $stmt->execute(); $res = $stmt->get_result(); $c = $res->fetch_assoc(); $class_id = $c['id'];

// create students
$students = ['Aisyah','Budi','Citra','Dedi','Eka','Fajar'];
foreach ($students as $sname) {
    $stmt = $db->prepare("SELECT id FROM students WHERE name = ? LIMIT 1"); $stmt->bind_param('s', $sname); $stmt->execute(); $res = $stmt->get_result();
    if (!$res->fetch_assoc()) {
        $stmt = $db->prepare("INSERT INTO students (name, class_id) VALUES (?, ?)");
        $stmt->bind_param('si', $sname, $class_id);
        $stmt->execute();
    }
}

// Insert some attendance for last 7 days
$statuses = ['Hadir','Sakit','Izin','Alpha'];
for ($d = 6; $d >= 0; $d--) {
    $date = date('Y-m-d', strtotime("-{$d} days"));
    // for each student, randomly assign status (deterministic using md5)
    $stmt = $db->prepare("SELECT id FROM students WHERE class_id = ?"); $stmt->bind_param('i', $class_id); $stmt->execute(); $res = $stmt->get_result();
    while ($row = $res->fetch_assoc()) {
        $sid = $row['id'];
        $seed = hexdec(substr(md5($sid.$date),0,6));
        $status = $statuses[$seed % count($statuses)];
        // avoid duplicate for same date/student
        $stmt2 = $db->prepare("SELECT id FROM attendance WHERE student_id = ? AND date = ? LIMIT 1");
        $stmt2->bind_param('is', $sid, $date); $stmt2->execute(); $r2 = $stmt2->get_result();
        if (!$r2->fetch_assoc()) {
            $stmt3 = $db->prepare("INSERT INTO attendance (class_id, student_id, date, status) VALUES (?, ?, ?, ?)");
            $stmt3->bind_param('iiss', $class_id, $sid, $date, $status);
            $stmt3->execute();
        }
    }
}

echo "Seeding selesai. Admin: admin/admin123, Guru: guru1/guru123\n";

?>