<?php
// vendor_install.php
// Run this from CLI or browser to download vendor assets into assets/vendor/

$list = [
    'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css' => 'assets/vendor/bootstrap.min.css',
    'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js' => 'assets/vendor/bootstrap.bundle.min.js',
    'https://code.jquery.com/jquery-3.7.1.min.js' => 'assets/vendor/jquery.min.js',
    'https://cdn.jsdelivr.net/npm/chart.js' => 'assets/vendor/chart.min.js',
    'https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css' => 'assets/vendor/jquery.dataTables.min.css',
    'https://cdn.datatables.net/responsive/2.5.0/css/responsive.dataTables.min.css' => 'assets/vendor/responsive.dataTables.min.css',
    'https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js' => 'assets/vendor/jquery.dataTables.min.js',
    'https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js' => 'assets/vendor/dataTables.responsive.min.js',
    'https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.js' => 'assets/vendor/sweetalert2.min.js',
    // fallback: DataTables button libs may be added later if desired
];

if (!is_dir(__DIR__ . '/assets')) mkdir(__DIR__ . '/assets');
if (!is_dir(__DIR__ . '/assets/vendor')) mkdir(__DIR__ . '/assets/vendor');

function download($url, $out)
{
    echo "Downloading $url -> $out\n";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'AbsensiVendorInstaller/1.0');
    $data = curl_exec($ch);
    $err = curl_error($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($data === false || $code >= 400) {
        echo "Failed to download $url (HTTP $code). Error: $err\n";
        return false;
    }
    file_put_contents($out, $data);
    echo "Saved: $out (" . strlen($data) . " bytes)\n";
    return true;
}

$success = 0;
$total = count($list);
foreach ($list as $u => $f) {
    $out = __DIR__ . '/' . $f;
    $dir = dirname($out);
    if (!is_dir($dir)) mkdir($dir, 0777, true);
    if (file_exists($out)) {
        echo "Skipping existing: $f\n";
        $success++;
        continue;
    }
    if (download($u, $out)) $success++;
}

echo "Finished: $success / $total files downloaded or already exist.\n";

if (php_sapi_name() === 'cli') exit;
